//	CCopyFile_Tree.h

#ifndef _H_CCopyFile_Tree
#define	_H_CCopyFile_Tree

#include "CCopyFile.h"

class	CCopyTree;

class	CCopyFile_Tree : public CCopyFile {
	
	public: OSErr	ICopyFile_Tree(
		CCopyFile		*parent0, 
		Ptr				myData);
		
	virtual	void	Dispose(void);
	virtual	void	LogCopyFileType(void);

	CCT_MemFileRecH	GetFileRecH(void);
	virtual	OSErr	GetFileInfo(CCT_MemFileRec *fileRecP);
	
	virtual	OSErr	IsFolder(Boolean *isFolderB);
	virtual	OSErr	CountFilesInFolder(ulong *numFilesL);
	virtual	OSErr	GetIndFileInFolder(ulong fileIndex, Ptr *fileDataP);

	virtual	OSErr	CreateFile(Ptr parentFolderP, CCT_MemFileRec *fileRecP);
	virtual	OSErr	SetFileInfo(CCT_MemFileRec *fileRecP);
	virtual	void	DisposeData(void);
	
	virtual	OSErr	Open(ADFS_IOType ioType, Boolean resForkB);
	virtual	OSErr	Close(void);

	virtual	OSErr	Read(ulong *bytesIO, char *bufP);
	virtual	OSErr	Write(ulong *bytesIO, char *bufP);
	
	virtual	OSErr	VerifyFreeSpace(CCT_CopyRec *copyRecP);
	virtual	OSErr	VerifyFileSize(CCopyFile *sourceP, ulong fileSizeL);
	virtual	OSErr	GetSizeSelf(CCT_CopyRec *copyRecP);

	virtual	OSErr	ScanForCopySelf(Ptr myDataP, CCopyFile **fileExistsH);

	virtual	OSErr	GetParentRef(Ptr *parentFolderH);
	virtual	OSErr	GetVolumeRef(Ptr *volumeH);

	virtual	Boolean	IsForked(void);
	virtual	Boolean	SupportsForks(void);
	virtual	OSErr	GetForkInfo(CCT_ForkInfo *forkInfoP);
	virtual	OSErr	SetForkInfo(CCT_ForkInfo *forkInfoP);
	/********************************************/
	ulong		i_fileSizeL;
	ulong		i_curFilePosL;
	
	typedef		CCopyFile		_inherited;
};

#endif